#include "univ.h"

char **ICache;
Carte **CCache;
Index I_SIZE, C_SIZE;

void CacheOp(p)
Protocol p;
{
	Index i;
	int j;
	register size;
	register Carte *c;
	register Index *rcv;
	char **oICache;
	Carte **oCCache;

	i = RcvLong();
	switch( (int) p ){
	case P_I_DEFINE:
		if (ICache) {
			oICache = ICache;
			ICache = (char **)Alloc(i * sizeof(char*));
			for(j = 0; j < I_SIZE; j++)
				ICache[j] = oICache[j];
			free(oICache);
		} else
			ICache = (char **)Alloc(i * sizeof(char*));
		I_SIZE = i;
		break;
	case P_C_DEFINE:
		if (CCache) {
			oCCache = CCache;
			CCache = (Carte**) Alloc(i * sizeof(Carte*));
			for(j = 0; j < C_SIZE; j++)
				CCache[j] = oCCache[j];
			free(oCCache);
		} else
			CCache = (Carte**) Alloc(i * sizeof(Carte*));
		C_SIZE = i;
		break;
	case P_I_CACHE:
		assert(!ICache[i]);
		RcvAllocString(&ICache[i]);
		break;
	case P_C_CACHE:
		assert(!CCache[i]);
		size = RcvLong();
		c = (Carte*) GCAlloc(CARTESIZE(size), &CCache[i]);
		c->attrib = RcvUChar();
		for (rcv = c->bin; size-- >= 0; *rcv++ = RcvLong())
			;
		c->size = RcvLong();			/* recursive size */
		c->width = RcvUChar();			/* recursive widest */
		break;
	default:
		ProtoErr("CacheOp(): ");

	}
}

char *IndexToStr(i)
Index i;
{
	assert(!(i & CARTE) && i < I_SIZE);
	return ICache[i];
}

Carte *IndexToCarte(i)
Index i;
{
	assert(i & CARTE);
	i &= ~CARTE;
	assert(i < C_SIZE && CCache[i]);
	return CCache[i];
}
